VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClanMember"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Enum ClanRanks
    rankNewPeon = 0
    rankPeon = 1
    rankGrunt = 2
    rankShaman = 3
    rankChieftain = 4
End Enum

Private m_Username As String
Private m_Rank As ClanRanks
Private m_Online As Boolean

Public Property Get Username() As String
    Username = m_Username
End Property

Public Property Let Username(ByVal newValue As String)
    m_Username = newValue
End Property

Public Property Get Rank() As ClanRanks
    Rank = m_Rank
End Property

Public Property Let Rank(ByVal newValue As ClanRanks)
    m_Rank = newValue
End Property

Public Property Get RankName() As String
    Select Case Rank
        Case rankNewPeon, rankPeon: RankName = "Peon"
        Case rankGrunt: RankName = "Grunt"
        Case rankShaman: RankName = "Shaman"
        Case rankChieftain: RankName = "Chieftain"
    End Select
End Property

Public Property Get Online() As Boolean
    Online = m_Online
End Property

Public Property Let Online(ByVal newValue As Boolean)
    m_Online = newValue
End Property

Public Function CompareTo(M As ClanMember) As Long
    Dim SCRes As Integer
    
    If Rank < M.Rank Then
        CompareTo = -1
        Exit Function
    ElseIf Rank > M.Rank Then
        CompareTo = 1
        Exit Function
    End If
    
    SCRes = StrComp(LCase$(M.Username), LCase$(Username))
    If SCRes < 0 Then
        CompareTo = -1
    ElseIf SCRes > 0 Then
        CompareTo = 1
    Else
        CompareTo = 0
    End If
End Function
